Include "hjglobal.jsh"
include "hjconst.jsh"
include "excel.jsh" ; constants and globals specific to Excel 97 and 2000 
include "excelall.jsh" ; constants and globals common to all versions of Excel
include "magic.jsh"

Const 
	strOExcel = "Excel.Application"

Globals
	Int theColumn,
	Int theRow,
	String strSelectedRange,
	String strTest1,
	String strTest2

; In order for these functions to be called properly, place the following lines in the AutoStartEvent function
; just prior to the line "if (ExcelFirstTime == 0) then."
;ScheduleFunction ("CheckForSelectionChange", 1)
;if (MagGetState () >= 0) then
;	ScheduleFunction ("CheckForSelectionChange", 1)
;EndIf

Void Function mInitializeOExcel ()
if !oExcel then
	let oExcel = MSOGetMenuBarObject ();
	let oExcel = oExcel.Application
	if !oExcel then
 		let oExcel = GetObject (strOExcel); "Excel.Application"
	EndIf
EndIf
EndFunction

OBJECT Function mGetCurrentCell ()
    mInitializeOExcel ()
return oExcel.Selection.Cells(1)
EndFunction

Int Function MagSetFocusInGrid ()
var int left, int top, int right, int bottom
if (MagGetState () <= 0) then return FALSE endif
if (IsKeyWaiting()) then return FALSE endif
if (GetWindowClass(GetFocus()) == wc7) then
  if (GetFocusRect (GetCurrentWindow (), left, right, top, bottom)) then
    MagSetFocusToRect(left, right, top, bottom, MTO_CARET)
    return TRUE
  endif
endif
return FALSE
EndFunction

Function CheckForSelectionChange ()
var Object curCell, Object objExcel, int prevColumn, 
	int prevRow, String prevSelectedRange, 
	Int nSelectionChanged, Int nSelectedRangeChanged,
	String prevTest1, String prevTest2, Int bSuccess, 
	Int nX, Int nY, Int nL, Int nR, Int nT, Int nB 
; Return without any further processing if MAGic is not running or the screen is not Magnified.
; However, schedule the function to run again in 1 tenth of a second to check if the MAGic status changes.
If (MagGetState () <= 0) then ScheduleFunction ("CheckForSelectionChange", 1) Return EndIf
If (GetWindowClass (GetCurrentWindow ()) != wc7) then  ScheduleFunction ("CheckForSelectionChange", 1) Return EndIf
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
Let bSuccess = GetFocusRect (GetCurrentWindow (), nL, nR, nT, nB)
If (!bSuccess) then Let bSuccess = GetFocusRect (GetCurrentWindow (), nL, nR, nT, nB) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
; Store the previous values of variables for comparison
Let prevColumn = theColumn
Let prevRow = theRow
Let prevSelectedRange = strSelectedRange
; Get the object that represents the current cell through the Microsoft Office Object Model
let curCell = mGetCurrentCell ()
; Innitialize the Microsoft Excel Object
InitializeOExcel ()
; Get the top level Microsoft Excel Object that represents the active window
Let objExcel = oExcel.ActiveWindow
; Break the object curCell into the column and row coordinates and test to determine if the coordinates have changed
if curCell then
	let theColumn = curCell.Column
	Let theRow = curCell.row
	If (theColumn != prevColumn || theRow != prevRow) then Let nSelectionChanged = 1 Else Let nSelectionChanged = 0 EndIf
EndIf
If (objExcel) then
	Let objExcel = objExcel.RangeSelection
	Let strSelectedRange = objExcel.Address
	If (strSelectedRange != prevSelectedRange) then Let nSelectedRangeChanged = 1 Else Let nSelectedRangeChanged = 0 EndIf
EndIf
Let prevTest1 = strTest1
Let prevTest2 = strTest2
Let strTest1 = StringSegment (strSelectedRange, ":", 1)
Let strTest2 = StringSegment (strSelectedRange, ":", 2)
If (nMode == 1) then Let strTest1 = strSelectedRange Let strTest2 = strTest1  EndIf
If (nSelectionChanged == 1 || nSelectedRangeChanged == 1) then
	If (nMode == 1) then MagSetFocusInGrid () EndIf ; Navigating only
	If (nMode == 2) then  ; Selecting cells or text
		If (strTest1 == prevTest1) then
			If (SelDir == 0) then
				MagFocusRight (nX, nY, nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
			ElIf (SelDir == 1) then
				MagFocusRight (nX, nY, nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
			EndIf
		ElIf (strTest2 == prevTest2) then
			If (SelDir == 0) then
				MagSetFocusToRect (nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
			ElIf (SelDir == 1) then
				MagSetFocusToRect (nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
			EndIf
		Else
			MagSetFocusToRect (nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
		EndIf
	EndIf
Else
	If (nMode == 2) then
		If (SelDir == 1) then
				MagFocusRight (nX, nY, nL - 10, nR + 10 , nT - 10, nB + 10, MTO_CARET)
		EndIf
	EndIf
EndIf
ScheduleFunction ("CheckForSelectionChange", 1)
EndFunction

